package misc;

/**
 * The class Debug supports debugging output. Changing the constants in
 * this file enables/disables debug output.
 *
 * @version 0.10 03 Nov 1996
 * @author <A HREF="http:www.th-darmstadt.de/~mkarsten">Martin Karsten</A>
 */
public class Debug {
	private static final boolean DEBUG = false;		// see method 'out'
	private static final boolean DEBUGL = false;	// see method 'outl'
	private static final boolean DEBUGA = false;   // see method 'outa'

	// normal debug messages
	public static void out( String message ) {
		if (DEBUG) System.err.println( Thread.currentThread().getName() + ": " + message );
	}
	// frequent debug messages in loops, etc.
	public static void outl( String message ) {
		if (DEBUGL) System.err.println( Thread.currentThread().getName() + ": " + message );
	}
	// very important debug messages in finalizers, etc.
	public static void outa( String message ) {
		if (DEBUGA) System.err.println( Thread.currentThread().getName() + ": " + message );
	}
} // End of class Debug
